<?php
//Odkomentujte nsledujc dek, pokud m skript bet na Windows
//define('Auth_OpenID_RAND_SOURCE', null); 

require_once "./Auth/OpenID/Consumer.php";
require_once "./Auth/OpenID/FileStore.php";
require_once "./Auth/OpenID/SReg.php";
    
session_start();

$trust_root = 'http://misc.maly.cz/openid/';
$return_to = $trust_root . 'login2-openid-finish.php';

//Cesta k loiti
$store_path = "./cache"; 
$store = new Auth_OpenID_FileStore($store_path);
$consumer = new Auth_OpenID_Consumer($store);

// Dokonen - krok 7 
$response = $consumer->complete($return_to);

//Ovme vsledek z $response->status
if ($response->status == Auth_OpenID_CANCEL) {
    $msg = 'Autentizace zrusena.';
} else if ($response->status == Auth_OpenID_FAILURE) {
    $msg = "Autentizace selhala: " . $response->message;
} else if ($response->status == Auth_OpenID_SUCCESS) {
    // Autentizace v poradku
    $openid = $response->getDisplayIdentifier();
    $esc_identity = htmlspecialchars($openid);

    $success = sprintf('V poradku overen jako ' .
                       '<a href="%s">%s</a>.',
                       $esc_identity, $esc_identity);

    if ($response->endpoint->canonicalID) {
        $escaped_canonicalID = htmlspecialchars($response->endpoint->canonicalID);
        $success .= '  (XRI CanonicalID: '.$escaped_canonicalID.') ';
    }

    //Zskn informac z rozen Simple Registration
    $sreg_resp = Auth_OpenID_SRegResponse::fromSuccessResponse($response);
    $sreg = $sreg_resp->contents();
    if (@$sreg['email']) {
        $success .= "  Mail: '".htmlspecialchars($sreg['email']) . "'";
    }
    if (@$sreg['nickname']) {
        $success .= "  Prezdivka: '".htmlspecialchars($sreg['nickname']) . "'";
    }
    if (@$sreg['fullname']) {
        $success .= "  Jmeno: '".htmlspecialchars($sreg['fullname']) . "'";
    }
  //Pihlen spn... vypeme hlku a pesmrujeme uivatele do
  //zabezpeen oblasti
  print($success);
  die();
}
//Pihlen selhalo.
print($msg);die();
?>