<?php
//Odkomentujte nsledujc dek, pokud m skript bet na Windows
//define('Auth_OpenID_RAND_SOURCE', null); 

require_once "./Auth/OpenID/Consumer.php";
require_once "./Auth/OpenID/FileStore.php";
require_once "./Auth/OpenID/SReg.php";

session_start();

$trust_root = 'http://misc.maly.cz/openid/';
$return_to = $trust_root . 'login2-openid-finish.php';

    //Cesta k loiti
    $store_path = "./cache"; 
    $store = new Auth_OpenID_FileStore($store_path);
    $consumer = new Auth_OpenID_Consumer($store);

    $openid = $_POST['openid'];

    // Kroky 2 - Discovery a 3 (na pozad)
    $auth_request = $consumer->begin($openid);

    if (!$auth_request) {
        die("Neni platne OpenID");
    }
    
    /**
     * Podme o daje ze SimpleRegister
     * Povinn budeme poadovat pezdvku,
     * voliteln pak skuten jmno a e-mail
     */               
    $sreg_request = Auth_OpenID_SRegRequest::build(
                    array('nickname'), 
                    array('fullname', 'email'));

    if ($sreg_request) {
        $auth_request->addExtension($sreg_request);
    }

    // Krok 4 - pesmrovn na server OpenID poskytovatele
    if ($auth_request->shouldSendRedirect()) {
      //Krtk poadavek a poadavky OpenID 1 jsou pesmrovny pes HTTP redirekt
        $redirect_url = $auth_request->redirectURL($trust_root, $return_to);
        if (Auth_OpenID::isFailure($redirect_url)) {
            print("Chyba pri presmerovani: " . $redirect_url->message);
            die();
        } else {
            header("Location: ".$redirect_url);
            die();
        }
    } else {
        // Dlouh OpenID 2 poadavky - vygenerujeme formul a JavaScript jej odele jako POST
        $form_id = 'openid_message';
        $form_html = $auth_request->htmlMarkup($trust_root, $return_to, false, array('id' => $form_id));

        if (Auth_OpenID::isFailure($form_html)) {
            print("Chyba pri presmerovani: " . $redirect_url->message);
            die();
        } else {
            print $form_html;
        }
    }

 
?>